#ifndef __DM_LEDS_H__
#define __DM_LEDS_H__

#include "dm_nutypedefs.h"

#ifdef __cplusplus
extern "C" {
#endif

// "common" led codes:

#define LED_HEARTBEAT                   0
#define LED_CRESNET                     1
#define LED_CIP_ONLINE                  2
#define LED_ERR                         3
#define LED_ACTIVITY                    4
#define LED_READY                       5       // Indicates that the box is on.
#define LED_VIDEO_ERROR                 6       // indicates that we detect errors in the video stream
#define LED_VIDEO_STABLE                7       // indicates that the device is receiving video
#define LED_ENET_ERROR                  8       // detect a wiring fault on the Cat5 cables it shall be red
#define LED_ENET_LINK                   9       // valid Ethernet link is detected to the control system over IP
#define LED_SETUP                       10
#define LED_VIDEO2_STABLE               11  // indicates that the device is receiving video on second port
#define LED_VIDEO3_STABLE               12  // indicates that the device is receiving video on third input
#define LED_TDM_LINK                    13  // indicates valid TDM link is detected
#define LED_VIDEO1_OUT_STABLE           14  // indicates that the device is transmiting video
#define LED_VIDEO2_OUT_STABLE           15
#define LED_VIDEO3_OUT_STABLE           16
#define LED_VIDEO4_OUT_STABLE           17
#define LED_VIDEO5_OUT_STABLE           18
#define LED_VIDEO6_OUT_STABLE           19
#define LED_VIDEO7_OUT_STABLE           20
#define LED_VIDEO8_OUT_STABLE           21
#define LED_USBHID                      22
#define LED_VIDEO1_IN_STABLE	          23
#define LED_SLOT_1				              24
#define LED_SLOT_2				              25
#define LED_SLOT_3				              26
#define LED_TEST_READY			            27
#define LED_INDETERMINATE		            28
#define LED_PASS				                29
#define LED_FAIL				                30
#define LED_PWR_FAULT				            31
#define LED_VIDEO4_STABLE               32
#define LED_VIDEO5_STABLE               33
#define LED_VIDEO6_STABLE               34
#define LED_VIDEO7_STABLE               35
#define LED_VIDEO8_STABLE               36

// LED indicates not present
#define NO_LED 0xFF

extern void LedsInit(void);
extern void LedControl(UINT32 led, BOOL on);
extern INT32 LedCmd(UINT32 ignore, char * cmd);
extern void InitSetUpLED_Driver(void);
extern void GiveupSetUpLED_Driver(void);

#ifdef __cplusplus
}
#endif

#endif

